//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Threading;

namespace ProfilingSamples
{
	public class LogicalThreadMain 
	{
		private ManualResetEvent [] asyncEvents;
		const int threadCount = 100;
		public LogicalThreadMain()
		{
			asyncEvents = new ManualResetEvent[threadCount];
			for(int i = 0;i < threadCount;i++)
			{
				asyncEvents[i] = new ManualResetEvent(false);
			}
		}
		void WorkerThread(Object number) 
		{
			int id = (int)number;
			// Upienie na 1 sekund w celu symulacji rzeczywistej pracy
			Thread.Sleep(1000);
			// Zasygnalizowanie koca operacji asynchronicznej.
			TimeSpan ts = new TimeSpan(Environment.TickCount);
			Console.WriteLine("{0} {1}", id, ts);
			asyncEvents[id].Set();
		}
		void TestThread()
		{
			try
			{
				while(true)
				{ 
					Console.WriteLine("Pocztek ----------------");
					for(int i = 0;i < threadCount;i++)
					{
						ThreadPool.QueueUserWorkItem(new WaitCallback(WorkerThread), i);
					}
					Console.WriteLine("Koniec ----------------");
					for(int i = 0;i < threadCount;i++)
					{
						asyncEvents[i].WaitOne();
						asyncEvents[i].Reset();
					}
				}
			}
			catch(Exception e)
			{
				Console.WriteLine("TestThread przerywa prac: {0}", e.Message);
			}
		}
		static void Main(string [] args)
		{
			LogicalThreadMain m = new LogicalThreadMain();
			Thread testThread = new Thread(new ThreadStart(m.TestThread));
			testThread.Start();
			string input = Console.ReadLine();
			testThread.Abort();
			testThread.Join();
		}
	}
}